/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns.data;

import com.supermartijn642.additionallanterns.LanternBlock;
import com.supermartijn642.additionallanterns.LanternColor;
import com.supermartijn642.additionallanterns.LanternMaterial;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;

public class LanternBlockStateProvider
extends BlockStateProvider {
    public LanternBlockStateProvider(GatherDataEvent e) {
        super(e.getGenerator(), "additionallanterns", e.getExistingFileHelper());
    }

    protected void registerStatesAndModels() {
        for (LanternMaterial material : LanternMaterial.values()) {
            this.addStates(material);
        }
    }

    public void addStates(LanternMaterial material) {
        this.addState(material, null);
        if (material.canBeColored) {
            for (LanternColor color : LanternColor.values()) {
                this.addState(material, color);
            }
        }
        if (material.hasChains) {
            this.addChainState(material);
        }
    }

    public void addState(LanternMaterial material, LanternColor color) {
        this.getVariantBuilder(material.getLanternBlock(color)).forAllStatesExcept(state -> new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(LanternBlockStateProvider.getModelLocation(material, color, (Boolean)state.m_61143_((Property)BlockStateProperties.f_61435_), (Boolean)state.m_61143_((Property)LanternBlock.ON), (Boolean)state.m_61143_((Property)LanternBlock.REDSTONE))))}, new Property[]{BlockStateProperties.f_61362_});
    }

    public void addChainState(LanternMaterial material) {
        this.getVariantBuilder((Block)material.getChainBlock()).forAllStatesExcept(state -> {
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_);
            ConfiguredModel model = new ConfiguredModel((ModelFile)this.models().getExistingFile(LanternBlockStateProvider.getChainModelLocation(material)), axis == Direction.Axis.X || axis == Direction.Axis.Z ? 90 : 0, axis == Direction.Axis.X ? 90 : 0, false);
            return new ConfiguredModel[]{model};
        }, new Property[]{BlockStateProperties.f_61362_});
    }

    public static ResourceLocation getModelLocation(LanternMaterial material, LanternColor color, boolean hanging, boolean on, boolean redstone) {
        boolean lit;
        boolean bl = lit = on != redstone;
        return color == null ? (hanging ? (lit ? new ResourceLocation("additionallanterns", "block/" + material.getSuffix() + "_hanging_lantern") : new ResourceLocation("additionallanterns", "block/" + material.getSuffix() + "_hanging_lantern_off")) : (lit ? new ResourceLocation("additionallanterns", "block/" + material.getSuffix() + "_lantern") : new ResourceLocation("additionallanterns", "block/" + material.getSuffix() + "_lantern_off"))) : (hanging ? (lit ? new ResourceLocation("additionallanterns", "block/" + color.getSuffix() + "_" + material.getSuffix() + "_hanging_lantern") : new ResourceLocation("additionallanterns", "block/" + color.getSuffix() + "_" + material.getSuffix() + "_hanging_lantern_off")) : (lit ? new ResourceLocation("additionallanterns", "block/" + color.getSuffix() + "_" + material.getSuffix() + "_lantern") : new ResourceLocation("additionallanterns", "block/" + color.getSuffix() + "_" + material.getSuffix() + "_lantern_off")));
    }

    public static ResourceLocation getChainModelLocation(LanternMaterial material) {
        return new ResourceLocation("additionallanterns", "block/" + material.getSuffix() + "_chain");
    }
}

